/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.bettertridentreturn;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.bettertridentreturn.neoforge.BetterTridentReturnModImpl;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class BetterTridentReturnMod {
    public static final String MOD_ID = "bettertridentreturn";
    private static final int OFFHAND_SLOT = -1;
    private static final int NOT_FOUND_SLOT = -2;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static DataComponentType<Integer> getTridentReturnDataType() {
        return BetterTridentReturnModImpl.getTridentReturnDataType();
    }

    public static void onItemUseFinish(Player player, ItemStack itemStack, int duration) {
        if (!(itemStack.getItem() instanceof TridentItem) || player.level().isClientSide()) {
            return;
        }
        if (itemStack.getItem().getUseDuration(itemStack, (LivingEntity)player) - duration < 10) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)player) <= 0) {
                return;
            }
        } else {
            return;
        }
        float f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)itemStack, (LivingEntity)player);
        if (f > 0.0f && player.isInWaterOrRain()) {
            return;
        }
        int slot = BetterTridentReturnMod.getSlotFor(player.getInventory(), itemStack);
        itemStack.set(BetterTridentReturnMod.getTridentReturnDataType(), (Object)slot);
    }

    public static void onPlayerTick(Player player) {
        for (ItemStack stack : player.getInventory().getNonEquipmentItems()) {
            BetterTridentReturnMod.checkStack(player, stack);
        }
    }

    public static void checkStack(Player player, ItemStack stack) {
        int curSlot;
        if (!(stack.getItem() instanceof TridentItem) || player.level().isClientSide()) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)stack, (Entity)player) <= 0) {
                return;
            }
        } else {
            return;
        }
        if (!stack.has(BetterTridentReturnMod.getTridentReturnDataType())) {
            return;
        }
        int slot = (Integer)stack.get(BetterTridentReturnMod.getTridentReturnDataType());
        if (slot != (curSlot = BetterTridentReturnMod.getSlotFor(player.getInventory(), stack))) {
            ItemStack fromSlot;
            if (slot == -1) {
                ItemStack fromSlot2 = player.getOffhandItem();
                if (fromSlot2.isEmpty()) {
                    player.getInventory().removeItemNoUpdate(curSlot);
                    stack.remove(BetterTridentReturnMod.getTridentReturnDataType());
                    player.getInventory().setItem(40, stack);
                }
            } else if (slot != -2 && (fromSlot = player.getInventory().getItem(slot)).isEmpty()) {
                player.getInventory().removeItemNoUpdate(curSlot);
                stack.remove(BetterTridentReturnMod.getTridentReturnDataType());
                player.getInventory().setItem(slot, stack);
            }
        }
    }

    public static int getSlotFor(Inventory inv, ItemStack stack) {
        for (int i = 0; i < inv.getNonEquipmentItems().size(); ++i) {
            if (((ItemStack)inv.getNonEquipmentItems().get(i)).isEmpty() || !BetterTridentReturnMod.stackEqualExact(stack, (ItemStack)inv.getNonEquipmentItems().get(i))) continue;
            return i;
        }
        if (!inv.getItem(40).isEmpty() && BetterTridentReturnMod.stackEqualExact(stack, inv.getItem(40))) {
            return -1;
        }
        return -2;
    }

    private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && ItemStack.matches((ItemStack)stack1, (ItemStack)stack2);
    }
}

